@echo off
setlocal enableDelayedExpansion

:: Script takes 2 optional arguments. Network subnet and arguments for nmap scan.
:: Example: nmap.bat -a "-O --script ssl-cert --osscan-limit" -s "10.0.0.1/24"
:: If no arguments are provided for nmap flags then the script uses arguments specificied in variable "default_scan"
:: If no arguments are provided for subnet range, then the script uses subnet range of host currently running the script.

:: Written by Infigo IS

:: Checking nmap install path
:: The install path of nmap can be specified in the nmap.path file
:: This checks each line of that file trying to find nmap
set nmap_path= 

for /f "usebackq delims=" %%a in ("%~dp0\nmap.path") do (
    set nmap_path="%%a"
    if exist "!nmap_path!" goto :continue
)
:nonmapfound
echo ERROR - nmap is not found on the machine, if nmap is installed please specify the path in the nmap.path file
exit /b 1

:continue

set default_scan="-p0-32000 -T4 -sV -O --script ssl-cert --osscan-limit"

:: Define the option names along with default values, using a <space>
:: delimiter between options.
::
:: Each option has the format -name:[default]
::
:: The option names are NOT case sensitive.
::
:: Options that have a default value expect the subsequent command line
:: argument to contain the value. If the option is not provided then the
:: option is set to the default. If the default contains spaces, contains
:: special characters, or starts with a colon, then it should be enclosed
:: within double quotes. The default can be undefined by specifying the
:: default as empty quotes "".
:: NOTE - defaults cannot contain * or ?
::
:: Options that are specified without any default value are simply flags
:: that are either defined or undefined. All flags start out undefined by
:: default and become defined if the option is supplied.
::
:: The order of the definitions is not important.
::
set "options=-s:/ -a:!default_scan!"

:: Set the default option values
for %%O in (!options!) do for /f "tokens=1,* delims=:" %%A in ("%%O") do set "%%A=%%~B"

:loop
:: Validate and store the options, one at a time, using a loop.
:: Options start at arg 1 in this example. Each SHIFT is done starting at
:: the first option so required args are preserved.
::
if not "%~1"=="" (
  set "test=!options:*%~1:=! "
  if "!test!"=="!options! " (
    echo Error: Invalid option %~1
    exit /b 1
  ) else if "!test:~0,1!"==" " (
    set "%~1=1"
  ) else (
    set "%~1=%~2"
    shift /1
  )
  shift /1
  goto :loop
)

:: Now all supplied options are stored in variables whose names are the
:: option names. Missing options have the default value, or are undefined if
:: there is no default.
:: The required args are still available in %1 and %2 (and %0 is also preserved)
::
:: set -

if "!-s!"=="/" (
  set n=0
  set address=

  Rem Extract subnets from host
  (for /f "tokens=3 delims=: " %%i  in ('netsh int ip show config ^| findstr "Subnet Prefix" ^') do (
    set ttt=%%i
    if /i not "!ttt:~0,9!"=="127.0.0.0" (
      set Addresses[!n!]=%%i 
      set /a n+=1
    )
  ))

  if !n!==0 (
    echo ERROR - Argument -s is null since no subnet was specificied and no subnet was found on host %COMPUTERNAME%. Appropriate format is: nmap.sh -a [arguments] -s [subnet]
    exit /b 1
  )

  set /a n-=1
  
  (for /L %%i in (0,1,!n!) do (
   set address=!Addresses[%%i]!!address!
  ))
  echo Since no subnet was provided, script will execute for subnet !address!
  start /wait /b "nmap" !nmap_path! !-a! !address!
) else (
  echo Scan executed for subnet !-s!
  start /wait /b "nmap" !nmap_path! !-a! !-s!
)


