#!/bin/bash

#Script takes 2 optional arguments. Network subnet and arguments for nmap scan. 
#Example: ./nmap.sh -a "-O --script ssl-cert --osscan-limit" -s "10.0.0.1/24"
#If no arguments are provided for nmap flags then the script uses arguments specificied in variable "default_scan"
#If no arguments are provided for subnet range, then the script uses subnet range of host currently running the script. 

#Written by Infigo IS


default_scan="-p0-32000 -T4 -sV -O --script ssl-cert --osscan-limit"

while getopts a:s: flag
do
    case "${flag}" in
        a) arguments=${OPTARG};;
        s) subnet=${OPTARG};;
    esac
done

if [ ! -n "$arguments" ]
then
        arguments=$default_scan
fi


if [ ! -n "$subnet" ]
then
	address=$(ip a | grep "inet[^6]" | egrep -v "127.0.0.1" )

	if [ -z "$address" ]; then
		echo >&2 "ERROR - Argument -s is null since no subnet was specificied and no subnet was found on host $(hostname). Appropriate format is: nmap.sh -a [arguments] -s [subnet]"
	    	exit 1
	fi
	echo >&2 "Since no subnet was provided, script will execute a scan for subnets available on the host $(hostname)"
	
	for ipset in $address; do
		if [[ $ipset =~ ^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\/ ]]
		then
			target="$ipset $target"
		fi
	done
	echo "Since no subnet was provided, scan executed for subnet $target"
	nmap $arguments $target	
else
	echo "Scan executed for subnet $subnet"
	nmap $arguments $subnet
fi

if [ $? -ne 0 ]; then
    echo >&2 "Nmap failed to run. Check the arguments."
fi

